#ifndef IOSC_DEV_H
#define IOSC_DEV_H

#define IOSC_COPY_DATA_MAX_LEN (1024)

/* definition of ioctl command */
#define IOSC_DEFINE_NODATACMD( type, nr )         IOSC_IOC(IOSC_IOC_NONE,(type),(nr),(0))
#define IOSC_DEFINE_READCMD( type, nr, size )     IOSC_IOC(IOSC_IOC_READ,(type),(nr),(size))
#define IOSC_DEFINE_WRITECMD( type, nr, size )    IOSC_IOC(IOSC_IOC_WRITE,(type),(nr),(size))
#define IOSC_DEFINE_RWCMD( type, nr, size )       IOSC_IOC(IOSC_IOC_RW,(type),(nr),size)
#define IOSC_DEFINE_DATA_RDCMD( type, nr, size )  IOSC_IOC(IOSC_IOC_DATARD,(type),(nr),(size))
#define IOSC_DEFINE_DATA_WRCMD( type, nr, size )  IOSC_IOC(IOSC_IOC_DATAWR,(type),(nr),(size))
#define IOSC_DEFINE_CMD( dir, type, nr, size )    IOSC_IOC( (dir), (type), (nr), (size) )
//#define IOSC_DEFINE_MMAP_RWCMD( type, nr, size )  IOSC_IOC(IOSC_IOC_MMAPRW,(type),(nr),(size))

/* macro of ioctl command */
#define IOSC_GET_CMDTYPE(cmd)    (((cmd) >> IOSC_IOC_TYPESHIFT) & IOSC_IOC_TYPEMASK)
#define IOSC_GET_CMDNR(cmd)      (((cmd) >> IOSC_IOC_NRSHIFT) & IOSC_IOC_NRMASK)
#define IOSC_GET_CMDSIZE(cmd)    (((cmd) >> IOSC_IOC_SIZESHIFT) & IOSC_IOC_SIZEMASK)
#define IOSC_GET_CMDDIR(cmd)     (((cmd) >> IOSC_IOC_DIRSHIFT) & IOSC_IOC_DIRMASK)

/* direction bits */
#define IOSC_IOC_NONE       (0U)
#define IOSC_IOC_WRITE      (1U)
#define IOSC_IOC_READ       (2U)
#define IOSC_IOC_RW         (3U)
#define IOSC_IOC_DATARD     (4U)
#define IOSC_IOC_DATAWR     (5U)
#define IOSC_IOC_RETURN     (6U)
#define IOSC_IOC_ERROR      (7U)
//#define IOSC_IOC_MMAPRW     (8U)
//#define IOSC_IOC_MMAPRET    (9U)

/* common command of communication driver */
#define IOSC_DEV_IOCPING            IOSC_DEFINE_NODATACMD( 0, 1)
#define IOSC_DEV_IOCSIG             IOSC_DEFINE_WRITECMD( 0, 2, sizeof(int))
#define IOSC_DEV_IOCGET_ID          IOSC_DEFINE_NODATACMD( 0, 3)
#define IOSC_DEV_IOCRELEASE_ID      IOSC_DEFINE_NODATACMD( 0, 4)
#define IOSC_DEV_IOCGET_CMD         IOSC_DEFINE_CMD( 0, 0, 10, sizeof(struct iosc_read_packet_t))
#define IOSC_DEV_IOCGET_DATA(cmd)   IOSC_DEFINE_CMD( 0, 0, 11, IOSC_GET_CMDSIZE(cmd) )
#define IOSC_DEV_IOCRETURN(cmd)     IOSC_DEFINE_CMD( IOSC_IOC_RETURN, 0, 12, IOSC_GET_CMDSIZE(cmd) )
#define IOSC_DEV_IOCERROR(cmd)      IOSC_DEFINE_CMD( IOSC_IOC_ERROR, 0, 13, IOSC_GET_CMDSIZE(cmd) )
//#define IOSC_DEV_IOCMMAPRET(cmd)    IOSC_DEFINE_CMD( IOSC_IOC_MMAPRET, 0, 14, IOSC_GET_CMDSIZE(cmd) )

struct iosc_read_packet_t {
  unsigned int cmd;
  unsigned int length;
  unsigned long arg;
};

struct iosc_mem_arg_t {
	unsigned int length;
	int memid;
	void *paddr;
	void *memaddr;
	int mmapflags;
};

#define IOSC_ALLOC_MEM	IOSC_DEFINE_RWCMD(2, 10, sizeof(struct iosc_mem_arg_t))
#define IOSC_FREE_MEM	IOSC_DEFINE_RWCMD(2, 11, sizeof(struct iosc_mem_arg_t))
#define IOSC_ATTACH_MEM	IOSC_DEFINE_RWCMD(2, 12, sizeof(struct iosc_mem_arg_t))
#define IOSC_DETACH_MEM	IOSC_DEFINE_RWCMD(2, 13, sizeof(struct iosc_mem_arg_t))

/* local definition */
#define IOSC_IOC_NRBITS     (8)       /* Max 256 commands */
#define IOSC_IOC_TYPEBITS   (7)       /* Max 128 devices */
#define IOSC_IOC_SIZEBITS   (13)      /* Max 8Kb */
#define IOSC_IOC_DIRBITS    (4)       /* Max 16 pattern */

#define IOSC_IOC_NRMASK     ((1 << IOSC_IOC_NRBITS)-1)
#define IOSC_IOC_TYPEMASK   ((1 << IOSC_IOC_TYPEBITS)-1)
#define IOSC_IOC_SIZEMASK   ((1 << IOSC_IOC_SIZEBITS)-1)
#define IOSC_IOC_DIRMASK    ((1 << IOSC_IOC_DIRBITS)-1)

#define IOSC_IOC_NRSHIFT    (0)
#define IOSC_IOC_TYPESHIFT  (IOSC_IOC_NRSHIFT+IOSC_IOC_NRBITS)
#define IOSC_IOC_SIZESHIFT  (IOSC_IOC_TYPESHIFT+IOSC_IOC_TYPEBITS)
#define IOSC_IOC_DIRSHIFT   (IOSC_IOC_SIZESHIFT+IOSC_IOC_SIZEBITS)

#define IOSC_IOC(dir,type,nr,size) \
    (((dir)     <<  IOSC_IOC_DIRSHIFT) | \
     ((type)    <<  IOSC_IOC_TYPESHIFT) | \
     ((nr)      <<  IOSC_IOC_NRSHIFT) | \
     ((size)    <<  IOSC_IOC_SIZESHIFT))

#endif /* IOSC_DEV_H */
